def solve():
    data = []
    
    try:
        while True:
            line = input()
            if not line:
                break
            data.extend(line.split())
    except EOFError:
        pass
    except Exception:
        return

    if not data:
        return

    iterator = iter(data)
    
    try:
        N = int(next(iterator))
        W = int(next(iterator))
        epsilon = float(next(iterator))
        
        items = []
        V_max = 0
        for i in range(N):
            w = int(next(iterator))
            v = int(next(iterator))
            items.append((w, v, i + 1))
            if v > V_max:
                V_max = v
    except (StopIteration, ValueError):
        return
    except Exception:
        return

    if N == 0 or V_max == 0:
        print(0)
        return

    K = epsilon * V_max / N
    if K == 0:
        K = 1
    
    scaled_items = []
    max_scaled_V = 0
    for w, v, index in items:
        v_prime = int(v / K)
        scaled_items.append((w, v_prime, index))
        max_scaled_V += v_prime

    INF = W + 1 
    dp = [INF] * (max_scaled_V + 1)
    dp[0] = 0
    
    parent = [None] * (max_scaled_V + 1)
    
    for w, v_prime, index in scaled_items:
        for j in range(max_scaled_V, v_prime - 1, -1):
            if dp[j - v_prime] != INF:
                new_weight = dp[j - v_prime] + w
                if new_weight < dp[j]:
                    dp[j] = new_weight
                    parent[j] = (j - v_prime, index)

    best_V_prime = 0
    for j in range(max_scaled_V, -1, -1):
        if dp[j] <= W:
            best_V_prime = j
            break
            
    selected_indices = []
    current_V_prime = best_V_prime
    
    while current_V_prime > 0 and parent[current_V_prime] is not None:
        prev_V_prime, index = parent[current_V_prime]
        selected_indices.append(index)
        current_V_prime = prev_V_prime

    print(len(selected_indices))
    print(*(selected_indices))

if __name__ == '__main__':
    solve()